package org.msh.tb.bd.dashboard.query;

import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio on 23/05/2017.
 */
public class Indicator09Query extends IndicatorQuery {

    @Override
    public List<Object[]> getDetailedResult(){
        // create administrative unit condition
        String auCondition;

        if (getSelectedAdminUnit() != null) {
            auCondition = "and au.code like '" + getSelectedAdminUnit().getCode() + "%' ";
            int level = getSelectedAdminUnit().getCountryStructure().getLevel() + 1;
            auCondition += "and au.countryStructure.level = " + level;
        } else {
            auCondition = "and au.countryStructure.level = 1 ";
        }

        //get database result and include for each result its rate
        List<Object[]> ret = includeRate(getQueryResult(auCondition));

        // calculate root
        long rootNum1 = 0;
        long rootNum2 = 0;
        long rootNum3 = 0;
        long rootNum4 = 0;

        for (Object[] o : ret){
            rootNum1 = rootNum1 + (Long)o[1];
            rootNum2 = rootNum2 + (Long)o[2];
            rootNum3 = rootNum3 + (Long)o[4];
            rootNum4 = rootNum4 + (Long)o[5];
        }

        Object[] root = new Object[] {"root", rootNum1, rootNum2, null, rootNum3, rootNum4, null};
        root[3] = calculateRate(new Object[]{rootNum1, rootNum2});
        root[6] = calculateRate(new Object[]{rootNum3, rootNum4});

        ret.add(root);

        return ret;
    }

    @Override
    protected List<Object[]> includeRate(List<Object[]> result) {
        List<Object[]> newResult = new ArrayList<Object[]>();

        for (Object[] o : result) {
            Object[] newObj = new Object[]{o[0],
                    o[1],
                    o[2],
                    calculateRate(new Object[]{o[1], o[2]}),
                    o[3],
                    o[4],
                    calculateRate(new Object[]{o[3], o[4]})};

            newResult.add(newObj);
        }

        return newResult;
    }

    @Override
    public Float calculateRate(Object[] o) {
        Long num1 = (Long) o[0];
        Long num2 = (Long) o[1];

        return DashboardIndicatorUtils.calcPercentage(num1, num2);
    }

    @Override
    protected List<Object[]> getQueryResult(String adminUnitCondition) {
        // query indicator result
        // get population by administrative units child of auSelected
        // get new and relapses cases notified inside each of these administrative units
        List<Object[]> result = getEntityManager().createQuery("select au.name.name1, " +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and c.infectionSite = 0 and c.caseDefinition = 0 and c.diagnosisType = 1 " +
                    "and c.patientType in (0,48) and c.followUpSmearStatus = 1 " + // new or treatment history unknown converted
                    "and p.workspace.id = :wsId)," +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and c.infectionSite = 0 and c.caseDefinition = 0 and c.diagnosisType = 1 " +
                    "and c.patientType in (0,48) " + // new or treatment history unknown
                    "and p.workspace.id = :wsId)," +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and c.infectionSite = 0 and c.caseDefinition = 0 and c.diagnosisType = 1 " +
                    "and c.patientType = 44 and c.followUpSmearStatus = 1 " + // previously treated converted
                    "and p.workspace.id = :wsId)," +
                "(select count(*) " +
                    "from TbCase c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and c.infectionSite = 0 and c.caseDefinition = 0 and c.diagnosisType = 1 " +
                    "and c.patientType = 44 " + // previously treated
                    "and p.workspace.id = :wsId)" +
                "from AdministrativeUnit au " +
                "where au.workspace.id = :wsId " + adminUnitCondition +
                "order by au.name.name1")
                .setParameter("iniDate", getIniDate())
                .setParameter("endDate", getEndDate())
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        return result;
    }
}
